/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2007 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       SCI_DRV.C               											
*														              					
* Description:	  SCI driver file for MC9S08DZ60	        	    	
*                 based on Specification Rev. 3  	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		

/* include files */

#include "derivative.h" /* include peripheral declarations */
#include "target.h"
#include "sci_drv.h"

tSCI *TerminalPointer; /* Global Variable indicating which SCI is in use */


/******************************************************************************
Function Name	:	SCI_Config
Parameters		:	NONE
Returns			  :	NONE
Notes			    :	Configures SCI
******************************************************************************/
void
SCI_Config(tSCI *sci_ptr, unsigned int prescaler)
{

		/* set baud rate */
	sci_ptr->SCIBD.Word = prescaler;
		/* set control register 1 */
	sci_ptr->SCICR1.Byte = 0x00;
		/* enable transmit */
	sci_ptr->SCICR2.Bits.TE = 1;
		/* enable receive */
	sci_ptr->SCICR2.Bits.RE = 1;
}


/******************************************************************************
Function Name	:	DisplayString
Parameters		:	textString[]
Returns			  :	NONE
Notes			    :	Output text string as ASCII to SCI
******************************************************************************/
void DisplayString (signed char *textPointer)
{
		/* while not end of string */
	while(*textPointer != 0)
	{	
			/* write the character to the SCI interface */
		PutChar(*textPointer);
			/* increment to point at the next character in the string */
		textPointer++;
	}	
}

/******************************************************************************
Function Name	:	DisplayByte
Parameters		:	displayByte
Returns			  :	NONE
Notes			    :	Output variable SCI after conversion to ASCII
******************************************************************************/
void DisplayByte (unsigned char displayByte)
{
	unsigned char upperNibble, lowerNibble;
		/* Split data into nibbles for ASCII conversion */
	upperNibble = ((displayByte & 0xF0)>>4); 
	lowerNibble = (displayByte & 0x0F);
		/* Pass nibbles to SCI after passing for conversion to ASCII */
	PutChar(convertASCII(upperNibble));
	PutChar(convertASCII(lowerNibble));
}

/******************************************************************************
Function Name	:	PutChar
Parameters		:	char to be output to SCI1
Returns			  :	NONE
Notes			    :	
******************************************************************************/
void PutChar(char ch) 
{
		/* check SCI transmit data register is empty */
	while(TerminalPointer->SCISR1.Bits.TDRE == 0)
	{
	}	
	TerminalPointer->SCIDR.Byte = ch;	
}

/******************************************************************************
Function Name	:	GetChar
Parameters		:	char to be output to SCI
Returns			  :	NONE
Notes			    :	
******************************************************************************/
char GetChar(void) 
{
		/* check SCI1 receive data register is empty */
	while(TerminalPointer->SCISR1.Bits.RDRF == 0)
	{
	}	
	return(TerminalPointer->SCIDR.Byte);	
}

/******************************************************************************
Function Name	:	EchoGetChar
Parameters		:	char to be output to SCI
Returns			  :	NONE
Notes			    :	
******************************************************************************/
char EchoGetChar(void) 
{
		/* check SCI1 receive data register is empty */
	while(TerminalPointer->SCISR1.Bits.RDRF == 0)
	{
	}	
	//echochar = TerminalPointer->SCIDR.Byte;
	PutChar(TerminalPointer->SCIDR.Byte);
	return(TerminalPointer->SCIDR.Byte);	
}


/******************************************************************************
Function Name	:	convertASCII
Parameters		:	Nibble of binary data (0000 to 1111) (unsigned char)
Returns			  :	ASCII code for nibble (unsigned char)
*******************************************************************************/
unsigned char convertASCII(unsigned char Nibble)
{	
	/* If nibble is less than 9 (ie. a number) */
	if (Nibble <= 0x09) 
		/* Return the ASCII code for this number */
		return (Nibble + 0x30); 
	else
		/* Return the ASCII code for this letter */
		return (Nibble + 0x37); 
} 

/******************************************************************************
Function Name	:	DisplayInt
Parameters		:	int count value to display tU08 field width
Returns			  :	NONE
Notes			    :	Effectively perforns a number to string conversion and then
					      outputs the string.
					      if field width = 0 then the int is displayed left justified   
					      with leading zeros supressed.
					      if field width = 1-5 then lowest n digits are displayed
					      with leading zeros.
					      This routine does not check that the field size is valid.					
******************************************************************************/
void 
DisplayInt(unsigned int number, unsigned char field ) 
{
	char buf[6];
	char i = 5;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the int into ascii -> string buffer */
		buf[--i] = (char)(number % 10) + '0';
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (5-i)) && (field != 0))
		i = 5 - field;
				/* if field width is more than number of digits add leading zeros */
	if (field > (5-i))
	{
		while ((5-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}
	
/******************************************************************************
Function Name	:	DisplayLong
Parameters		:	long count value to display tU08 field width
Returns			  :	NONE
Notes			    :	Direct replacement for NumberDisplay().

					      Effectively perforns a number to string conversion and then
					      outputs the string.
					      if field width = 0 then the int is displayed left justified   
					      with leading zeros supressed.
					      if field width = 1-10 then lowest n digits are displayed
					      with leading zeros.
					      This routine does not check that the field size is valid.
					
					      Due to the 32 bit math routines for handling long values
					      code size and execution time is significantly larger that
					      for DisplayInt.
******************************************************************************/
void 
DisplayLong(unsigned long number, unsigned char field ) 
{
	char buf[11];
	char i = 10;
	char length = 0;

	buf[i] = 0;
			/* for upto 10 digits : max value for long = 4294967296 */
			/* using a do while loop to take care of the number = 0 */
	do
	{
				/* convert least significant character of the int into ascii -> string buffer */
		buf[--i] = (char)(number % 10) + '0';
				/* moves next digit to least significant position */
		number /= 10;
	} while (number != 0); 
				/* if field width is less than number of digits only o/p field width of string */
	if ((field < (10-i)) && (field != 0))
		i = 10 - field;
				/* if field width is more than number of digits add leading zeros */
	if (field > (10-i))
	{
		while ((10-i) < field)
	    {
				/* add leading zeros */ 
		buf[--i] = '0';
		}
	}
	DisplayString(&buf[i] );	
}	
